//== INCLUDES =================================================================


#include "cgal_performance.h"
#include "surface_mesh_performance.h"
#include "openmesh_performance.h"
#include "mesquite_performance.h"


//=============================================================================


int main(int argc, char** argv)
{
    if (argc != 2)
    {
        std::cerr << "Usage:\nperformance <input-mesh>\n";
        exit(1);
    }

    {
        std::cout << "Mesquite\t" << std::endl;
        Mesquite_performance().run(argv[1], "output_mesquite.off");
    }

    {
        std::cout << "CGAL\t" << std::endl;
        CGAL_performance().run(argv[1], "output_cgal.off");
    }

    {
        std::cout << "OpenMesh\t" << std::endl;
        OpenMesh_performance().run(argv[1], "output_openmesh.off");
    }

    {
        std::cout << "Surface_mesh\t" << std::endl;
        Surface_mesh_performance().run(argv[1], "output_surface_mesh.off");
    }

    return 0;
}


//=============================================================================
